<?php

namespace App\Http\Controllers;

use App\Models\User;
//use Illuminate\Container\Attributes\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Redirect;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Auth as FacadesAuth;

class LoginController extends Controller
{
    //
    public function index(){
        return view('login');
    }

    public function authenticate(Request $request){
       // dd($request->all());
        $validator = Validator::make($request->all(),[
            'email'=>'required|email',
            'password'=>'required',
        ]);

        if($validator->passes()){

            // if(Auth::attempt(['email'=>$request->email,'password'=>$request->password])){
            //      return redirect()->route('user.dashboard')->with('success','Login Successfull.'); 
            // }else{
            //    return redirect()->route('user.login')->with('error','Invalid login credentials.'); 
            // }

  if(Auth::guard('web')->attempt(['email'=>$request->email,'password'=>$request->password])){
                if(Auth::guard('web')->user()->guard != 'web'){
                    Auth::guard('web')->logout();
                     return redirect()->back()->withInput()->with('error','Invalid login credentials. You are not authorised to access this page');
                }
                 return redirect()->route('user.dashboard')->with('success','Login Successfull.'); 
            }else{
               return redirect()->back()->with('error','Invalid login credentials.'); 
            }

//dd('asdasdasd');
        }else{
            return redirect()->route('user.login')->withInput()->withErrors($validator);
        }


    }


    public function register(){
        return view('register');
    }

    public function processRegister(Request $request){
          // dd($request->all());
        $validator = Validator::make($request->all(),[
            'name'=>'required',
            'email'=>'required|email|unique:users',
            'password'=>'required|confirmed:password_confirmation',
        ]);

        if($validator->passes()){
            $user = new User();

            $user->name = $request->name; 
            $user->email = $request->email; 
            $user->password = Hash::make($request->password); 
            $user->role = 'user'; 
            $user->guard = 'web'; 

            $user->save();
              return redirect()->route('user.login')->with('success','Registration successful!');
//dd('asdasdasd');
        }else{
            return redirect()->route('user.register')->withInput()->withErrors($validator);
        }

    }

      public function logout(){
         Auth::guard('web')->logout();
        Auth::logout();
        return view('login');
    }
}
